VERSION 5.00
Begin VB.Form frmEZScan_SICL 
   Caption         =   "Form1"
   ClientHeight    =   3600
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5250
   LinkTopic       =   "Form1"
   ScaleHeight     =   3600
   ScaleWidth      =   5250
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txtReadings 
      Height          =   3135
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   1
      Text            =   "frmEZScan_SICL.frx":0000
      Top             =   240
      Width           =   2175
   End
   Begin VB.CommandButton cmdScan 
      Caption         =   "Start Scan"
      Height          =   855
      Left            =   2640
      TabIndex        =   0
      Top             =   240
      Width           =   2295
   End
End
Attribute VB_Name = "frmEZScan_SICL"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'' """""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
''    Copyright  2002 Agilent Technologies Inc. All rights
''    reserved.
''
'' You have a royalty-free right to use, modify, reproduce and distribute
'' the Sample Application Files (and/or any modified version) in any way
'' you find useful, provided that you agree that Agilent has no
'' warranty,  obligations or liability for any Sample Application Files.
''
'' Agilent Technologies provides programming examples for illustration only,
'' This sample program assumes that you are familiar with the programming
'' language being demonstrated and the tools used to create and debug
'' procedures. Agilent support engineers can help explain the
'' functionality of Agilent software components and associated
'' commands, but they will not modify these samples to provide added
'' functionality or construct procedures to meet your specific needs.
'' """"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
'
' This code implements a simple scan with the 34970A using the Agilent SICL IO
' Library version L 02.01
'
Const DAQ_ADDRESS = "gpib0,9"
Dim DAQ As Integer


Private Sub cmdScan_Click()
' initialize io object set the functions and then scan
    Dim readings() As Double
    Dim cmd As String
    Dim fmt As String
    Dim numargs As Integer
    Dim strres As String * 20
    Dim readingCount As Integer
    Dim i As Long


    initialize_IO
    
    ' Stop any ongoing scan
    cmd = "Abort"
    numargs = ivprintf(DAQ, cmd & Chr$(10))

    ' reset instrument
    cmd = "*RST"
    numargs = ivprintf(DAQ, cmd & Chr$(10))

    ' configure for DC and Resistance
    cmd = "Conf:volt:DC Auto,(@101,102);:Volt:DC:NPLC 0.02,(@101,102)"
    numargs = ivprintf(DAQ, cmd & Chr$(10))
    cmd = "Conf:Res Auto,(@106:108);:Res:NPLC 0.02,(@106:108)"
    numargs = ivprintf(DAQ, cmd & Chr$(10))
    cmd = "Route:Scan (@101,102,106:108)"
    numargs = ivprintf(DAQ, cmd & Chr$(10))
    
    ' determine the size of the scan
    cmd = "Rout:Scan:Size?"
    numargs = ivprintf(DAQ, cmd & Chr$(10))
    numargs = ivscanf(DAQ, "%d", readingCount)
    
    ' initialize and wait for the scan to complete
    cmd = "INIT"
    numargs = ivprintf(DAQ, cmd & Chr$(10))
    cmd = "*OPC?"
    numargs = ivprintf(DAQ, cmd & Chr$(10))
    numargs = ivscanf(DAQ, "%t" & Chr$(10), strres)

    cmd = "Fetch?"
    numargs = ivprintf(DAQ, cmd & Chr$(10))
    ' dimension the array for the size needed
    ReDim readings(readingCount - 1)
    fmt = "%," & Format$(readingCount) & "lf"

    ' return measurement as a double array
    numargs = ivscanf(DAQ, fmt, readings(0))
    

With txtReadings
    .Text = ""
    .SelText = Now & vbCrLf
    For i = 0 To UBound(readings)
        .SelText = readings(i) & vbCrLf
    Next i
End With

Cleanup

End Sub

' initializes the GPIB port
Public Sub initialize_IO()
    Dim msg As String
    Dim intf_id As Integer                                 ' interface session id

    On Error GoTo InitializeError

    '  Open a device session using the device address

    DAQ = iopen(DAQ_ADDRESS)
    intf_id = igetintfsess(DAQ)
    Call iclear(intf_id)
    Call itimeout(DAQ, 5000)

    Exit Sub
InitializeError:
    Debug.Print "Error in initialize_IO; "; Err.Description
    MsgBox "Error initializing 34970A" & vbCrLf & Err.Description
End Sub

Public Sub Cleanup()
    On Error Resume Next

    Call iclose(DAQ)
    Call siclcleanup
End Sub



